<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Yotpo compatibility by Amasty for Magento 2 (System)
 */

namespace Amasty\Yotpo\Plugin\Framework\Data\Form\FormKey;

use Closure;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Data\Form\FormKey\Validator;

class ValidatorPlugin
{
    /**
     * @var array
     */
    private $ignoreActions = [
        'amyotpo_review_update'
    ];

    /**
     * @param Validator $validator
     * @param Closure $proceed
     * @param RequestInterface $request
     * @return bool|mixed
     */
    public function aroundValidate(Validator $validator, Closure $proceed, RequestInterface $request)
    {
        if (in_array($request->getFullActionName(), $this->ignoreActions)) {
            $result = true;
        } else {
            $result = $proceed($request);
        }

        return $result;
    }
}
