<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Yotpo compatibility by Amasty for Magento 2 (System)
 */

namespace Amasty\Yotpo\Model;

use Amasty\Yotpo\Model\ResourceModel\YotpoReview as YotpoReviewResource;
use Magento\Framework\Model\AbstractModel;

/**
 * @method float getRatingSummary()
 * @method int getTotalReviews()
 * @method int getStoreId()
 * @method int getProductId()
 * @method YotpoReview setRatingSummary(float $ratingSummary)
 * @method YotpoReview setTotalReviews(int $totalReviews)
 */
class YotpoReview extends AbstractModel
{
    public function _construct()
    {
        $this->setIdFieldName(YotpoReviewResource::PRODUCT_ID);
        $this->_setResourceModel(YotpoReviewResource::class);
    }

    /**
     * @param array $scoreInfo
     * @param bool $up
     */
    public function calculateAverageScore($scoreInfo, $up = true)
    {
        if (isset($scoreInfo['score']) && isset($scoreInfo['count'])) {
            if ($up) {
                $score = $this->getRatingSummary() * $this->getTotalReviews() + $scoreInfo['score'];
                $total = $this->getTotalReviews() + $scoreInfo['count'];
            } else {
                $score = $this->getRatingSummary() * $this->getTotalReviews() - $scoreInfo['score'];
                $total = $this->getTotalReviews() - $scoreInfo['count'];
            }
            $this->setRatingSummary($this->calcRatingSummary($score, $total));
            $this->setTotalReviews($total);
        }
    }

    /**
     * @param $score
     * @param $total
     * @return float
     */
    private function calcRatingSummary($score, $total)
    {
        if ($total) {
            $result = round($score / $total, 2);
        } else {
            $result = 0;
        }

        return $result;
    }
}
