<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Yotpo compatibility by Amasty for Magento 2 (System)
 */

namespace Amasty\Yotpo\Model\ResourceModel\YotpoReview;

use Amasty\Yotpo\Model\ResourceModel\YotpoReview as YotpoReviewResource;
use Amasty\Yotpo\Model\YotpoReview;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class Collection extends AbstractCollection
{
    protected function _construct()
    {
        $this->_init(
            YotpoReview::class,
            YotpoReviewResource::class
        );
    }

    /**
     * @param array $ids
     * @return $this
     */
    public function addIdFilter($ids)
    {
        $this->addFieldToFilter(YotpoReviewResource::PRODUCT_ID, ['in' => $ids]);

        return $this;
    }

    /**
     * @param array $storeIds
     * @return $this
     */
    public function addStoreFilter($storeIds)
    {
        $this->addFieldToFilter(YotpoReviewResource::STORE_ID, ['in' => $storeIds]);

        return $this;
    }
}
