<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Yotpo compatibility by Amasty for Magento 2 (System)
 */

namespace Amasty\Yotpo\Model\ResourceModel;

use Amasty\Yotpo\Model\YotpoReview as YotpoReviewModel;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class YotpoReview extends AbstractDb
{
    public const MAIN_TABLE = 'amasty_yotpo_review';

    public const PRODUCT_ID = 'product_id';
    public const STORE_ID = 'store_id';
    public const RATING_SUMMARY = 'rating_summary';
    public const TOTAL_REVIEWS = 'total_reviews';

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_setMainTable(self::MAIN_TABLE);
    }

    /**
     * @param $insertData
     * @throws LocalizedException
     */
    public function insertOnDuplicate($insertData)
    {
        $this->getConnection()->insertOnDuplicate($this->getMainTable(), $insertData);
    }

    /**
     * @param $insertData
     * @throws LocalizedException
     */
    public function insert($insertData)
    {
        $this->getConnection()->insert($this->getMainTable(), $insertData);
    }
}
