<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Yotpo compatibility by Amasty for Magento 2 (System)
 */

namespace Amasty\Yotpo\Model\Cron;

use Magento\Indexer\Model\Indexer;
use Magento\Indexer\Model\IndexerFactory;

class Index
{
    public const YOTPO_INDEXER_ID = 'amasty_yotpo_review';

    /**
     * @var IndexerFactory
     */
    private $indexerFactory;

    public function __construct(IndexerFactory $indexerFactory)
    {
        $this->indexerFactory = $indexerFactory;
    }

    /**
     * @throws \Throwable
     */
    public function reindex()
    {
        /** @var Indexer $indexer */
        if ($indexer = $this->indexerFactory->create()->load(self::YOTPO_INDEXER_ID)) {
            $indexer->reindexAll();
        }
    }
}
