<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Yotpo compatibility by Amasty for Magento 2 (System)
 */

namespace Amasty\Yotpo\Controller\Token;

use Amasty\Yotpo\Model\Yotpo\Client;
use Amasty\Yotpo\Model\ConfigProvider;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Store\Model\Store;

class Save extends Action
{
    /**
     * @var Client
     */
    private $client;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        Client $client,
        ConfigProvider $configProvider,
        Context $context
    ) {
        parent::__construct($context);
        $this->client = $client;
        $this->configProvider = $configProvider;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        if (!$this->checkInternalToken()) {
            $resultForward = $this->resultFactory->create(ResultFactory::TYPE_FORWARD);
            return $resultForward->forward('noroute');
        }

        $token = $this->getRequest()->getParam('token');
        $error = '';
        $storeId = $this->getRequest()->getParam('store_id', Store::DEFAULT_STORE_ID);

        try {
            $this->configProvider->saveAccessToken($token, $storeId);
        } catch (\Exception $e) {
            $error = $e->getMessage();
        }

        $resultJson = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        $resultData = [
            'success' => empty($error),
            'message' => $error
        ];

        return $resultJson->setData($resultData);
    }

    /**
     * @return bool
     */
    private function checkInternalToken()
    {
        return $this->getRequest()->getParam('internal_token') === $this->configProvider->getInternalToken();
    }
}
