<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Yotpo compatibility by Amasty for Magento 2 (System)
 */

namespace Amasty\Yotpo\Controller\Oauth;

use Amasty\Yotpo\Model\ConfigProvider;
use Amasty\Yotpo\Model\Yotpo\Client;
use Magento\Backend\Block\Template;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\Raw;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\LayoutInterface;

class Callback extends Action
{
    /**
     * @var Client
     */
    private $client;

    /**
     * @var LayoutInterface
     */
    private $layout;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ConfigProvider $configProvider,
        Client $client,
        LayoutInterface $layout,
        Context $context
    ) {
        parent::__construct($context);
        $this->client = $client;
        $this->layout = $layout;
        $this->configProvider = $configProvider;
    }

    /**
     * @inheritdoc
     */
    public function execute()
    {
        if (!$this->checkInternalToken()) {
            $resultForward = $this->resultFactory->create(ResultFactory::TYPE_FORWARD);
            return $resultForward->forward('noroute');
        }

        try {
            $storeId = $this->getRequest()->getParam('store_id');
            $accessToken = $this->configProvider->getAccessToken($storeId);
            $message = __('Success!');
        } catch (LocalizedException $exception) {
            $message = $exception->getMessage();
            $accessToken = null;
        }

        /** @var Raw $resultRaw */
        $resultRaw = $this->resultFactory->create(ResultFactory::TYPE_RAW);
        $resultRaw->setHeader(
            'Cache-Control',
            'no-store, no-cache, must-revalidate, max-age=0',
            true
        );

        return $resultRaw->setContents($this->getResultText($message, $accessToken));
    }

    /**
     * @param string $message
     * @param null|string $accessToken
     * @return string
     */
    private function getResultText($message, $accessToken)
    {
        /** @var Template $resultBlock */
        $resultBlock = $this->layout->createBlock(Template::class, '', [
            'data' => [
                'template' => 'Amasty_Yotpo::system/config/oauth/result.phtml',
                'access_token' => $accessToken,
                'message' => $message . ' ' . __('Generate Access Token')
            ]
        ]);

        return $resultBlock->toHtml();
    }

    private function checkInternalToken(): bool
    {
        return $this->getRequest()->getParam('internal_token') === $this->configProvider->getInternalToken();
    }
}
