<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Yotpo compatibility by Amasty for Magento 2 (System)
 */

namespace Amasty\Yotpo\Block\Adminhtml\System\Config\Yotpo;

use Amasty\Yotpo\Model\Yotpo\Client;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\Json\EncoderInterface;

class AccessToken extends Field
{
    /**
     * @var EncoderInterface
     */
    private $jsonEncoder;
    /**
     * @var Client
     */
    private $client;

    public function __construct(
        Client $client,
        \Magento\Backend\Block\Template\Context $context,
        EncoderInterface $jsonEncoder,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->jsonEncoder = $jsonEncoder;
        $this->client = $client;
    }

    /**
     * @return $this
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        $this->setTemplate('Amasty_Yotpo::system/config/access_token.phtml');

        return $this;
    }

    /**
     * @param AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element = clone $element;
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();

        return parent::render($element);
    }

    /**
     * @return bool
     */
    private function getIsTokenSet()
    {
        return (bool) $this->client->getAccessTokenFromConfig(null);
    }

    /**
     * @param AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $originalData = $element->getOriginalData();
        $label = $this->getIsTokenSet() ? __('Re-generate Access Token') : __($originalData['button_label']);
        $this->addData(
            [
                'button_label' => $label,
                'json_config' => $this->generateButtonConfig($element),
                'html_id' => $element->getHtmlId()
            ]
        );

        return $this->_toHtml();
    }

    /**
     * @param $element
     * @return mixed
     */
    private function generateButtonConfig(AbstractElement $element)
    {
        $result = [
            'authorize_url' => $this->client->getAuthorizeUrl($element->getScopeId()),
        ];

        return $this->jsonEncoder->encode($result);
    }

    /**
     * @return bool
     */
    public function getIsConnectionSecure()
    {
        return $this->client->getIsRefererSecure();
    }
}
