<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

use Amasty\Xlanding\Api\Data\PageInterface;
use Amasty\Xlanding\Api\PageRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

$objectManager = Bootstrap::getObjectManager();

/** @var PageRepositoryInterface $landingPageRepository */
$landingPageRepository = $objectManager->get(PageRepositoryInterface::class);

/** @var PageInterface $landingPage */
$landingPage = $objectManager->get(PageInterface::class);

$landingPage = $landingPageRepository->getByUrlKey('amIdent2023');
$landingPageRepository->delete($landingPage);

Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/simple_product_rollback.php');
