<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

use Amasty\Xlanding\Api\Data\PageInterface;
use Amasty\Xlanding\Api\PageRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/simple_product.php');

$objectManager = Bootstrap::getObjectManager();

/** @var PageRepositoryInterface $landingPageRepository */
$landingPageRepository = $objectManager->get(PageRepositoryInterface::class);

/** @var PageInterface $landingPage */
$landingPage = $objectManager->get(PageInterface::class);

$condition = [
    'type' => Amasty\Xlanding\Model\Rule\Condition\Combine::class,
    'attribute' => null,
    'operator' => null,
    'value' => '1',
    'is_value_processed' => null,
    'aggregator' => 'all',
    'conditions' => [
        (object)[
            'type' => Amasty\Xlanding\Model\Rule\Condition\Product::class,
            'attribute' => 'sku',
            'operator' => '==',
            'value' => 'simple_product',
            'is_value_processed' => false,
        ]
    ]
];

$metaData = [
    '1' => (object)[
        'meta_title_1' => '',
        'meta_keywords_1' => '',
        'meta_description_1' => '',
        'meta_robots_1' => 'INDEX,FOLLOW'
    ]
];

$landingPage->setTitle('Amasty Test Landing Title');
$landingPage->setIdentifier('amIdent2023');
$landingPage->setPageLayout('2columns-left');
$landingPage->setLayoutColumnsCount(3);
$landingPage->setLayoutIncludeNavigation(1);
$landingPage->setLayoutHeading('Amasty Test Layout Heading');
$landingPage->setLayoutTopDescription('Amasty Layout Top Description');
$landingPage->setLayoutBottomDescription('Amasty Layout Bottom Description');
$landingPage->setDefaultSortBy('position');
$landingPage->setIsActive(1);
$landingPage->setConditionsSerialized(json_encode($condition));
$landingPage->setMetaData(json_encode($metaData));
$landingPage->setDynamicCategoryId(0);
$landingPage->setStores('0');

$landingPageRepository->save($landingPage);
