<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

namespace Amasty\XlandingGraphQl\Test\GraphQl;

use Amasty\Xlanding\Api\PageRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class GetAmLandingTest extends GraphQlAbstract
{
    private const MAIN_RESPONSE_KEY = 'amlanding';

    /**
     * @var PageRepositoryInterface
     */
    private $landingPageRepository;

    protected function setUp(): void
    {
        parent::setUp();

        $objectManager = Bootstrap::getObjectManager();
        $this->landingPageRepository = $objectManager->get(PageRepositoryInterface::class);
    }

    /**
     * @group amasty_xlanding
     *
     * @magentoApiDataFixture Amasty_XlandingGraphQl::Test/GraphQl/_files/create_landing_page.php
     */
    public function testAmLanding(): void
    {
        $landingId = $this->landingPageRepository->getByUrlKey('amIdent2023')->getPageId();
        $assertArray = [
            'default_sort_by' => 'position',
            'dynamic_category_id' => 0,
            'identifier' => 'amIdent2023',
            'is_active' => 1,
            'layout_bottom_description' => 'Amasty Layout Bottom Description',
            'layout_columns_count' => 3,
            'layout_heading' => 'Amasty Test Layout Heading',
            'layout_top_description' => 'Amasty Layout Top Description',
            'meta_data' => '[{"meta_title":"","meta_keywords":"","meta_description":"","meta_robots":"INDEX,FOLLOW"}]',
            'page_id' => $landingId,
            'page_layout' => '2columns-left',
            'sort_order' => '0',
            'store_id' => [
                0 => '0'
            ],
            'title' => 'Amasty Test Landing Title'
        ];

        $query = $this->getQuery((int)$landingId);
        $response = $this->graphQlQuery($query);

        // assert main response fields
        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_RESPONSE_KEY], $assertArray);

        // assert other response fields
        $this->assertStringContainsString(
            'simple_product',
            $response[self::MAIN_RESPONSE_KEY]['conditions_serialized']
        );
        $this->assertArrayHasKey('creation_time', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('dynamic_category_url', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('layout_file', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('layout_file_alt', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('layout_include_navigation', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('layout_static_bottom', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('layout_static_top', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('layout_update_xml', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('relative_url', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('type', $response[self::MAIN_RESPONSE_KEY]);
        $this->assertArrayHasKey('update_time', $response[self::MAIN_RESPONSE_KEY]);
    }

    private function getQuery(int $landingId): string
    {
        return <<<QUERY
query {
  amlanding(id:$landingId) {
    conditions_serialized
    creation_time
    default_sort_by
    dynamic_category_id
    dynamic_category_url
    identifier
    is_active
    layout_bottom_description
    layout_columns_count
    layout_file
    layout_file_alt
    layout_heading
    layout_include_navigation
    layout_static_bottom
    layout_static_top
    layout_top_description
    layout_update_xml
    meta_data
    page_id
    page_layout
    relative_url
    sort_order
    store_id
    title
    type
    update_time
  }
}
QUERY;
    }
}
