<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

namespace Amasty\XlandingGraphQl\Plugin\CatalogGraphQl\Model\Resolver\Products\Query;

use Amasty\Xlanding\Model\Repository\PageRepository;
use Magento\CatalogGraphQl\Model\Resolver\Products\Query\Search;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Framework\Registry;

class SearchPlugin
{
    /**
     * @var Registry
     */
    private $coreRegistry;

    /**
     * @var PageRepository
     */
    private $pageRepository;

    public function __construct(
        Registry $coreRegistry,
        PageRepository $pageRepository
    ) {
        $this->coreRegistry = $coreRegistry;
        $this->pageRepository = $pageRepository;
    }

    public function beforeGetResult(Search $subject, array $args, ResolveInfo $info, $context)
    {
        if (isset($args['filter']['landing_page_id']['eq'])) {
            $page = $this->pageRepository->getById($args['filter']['landing_page_id']['eq']);
            if ($page) {
                $this->coreRegistry->register('amasty_xlanding_page', $page);
            }
        }

        return null;
    }
}
