<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

namespace Amasty\XlandingGraphQl\Plugin\CatalogGraphQl\Model\Resolver\Products\DataProvider\Product;

use Amasty\Xlanding\Api\Data\PageInterface;
use Amasty\Xlanding\Model\ResourceModel\AddPositionIndexJoin;
use Magento\Catalog\Model\ResourceModel\Product\Collection;
use Magento\CatalogGraphQl\Model\Resolver\Products\DataProvider\Product\CompositeCollectionProcessor;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Registry;

class CompositeCollectionProcessorPlugin
{
    /**
     * @var AddPositionIndexJoin
     */
    private $addPositionIndexJoin;

    /**
     * @var Registry
     */
    private $registry;

    public function __construct(
        AddPositionIndexJoin $addPositionIndexJoin,
        Registry $registry
    ) {
        $this->addPositionIndexJoin = $addPositionIndexJoin;
        $this->registry = $registry;
    }

    public function afterProcess(
        CompositeCollectionProcessor $subject,
        Collection $result,
        Collection $collection,
        SearchCriteriaInterface $searchCriteria,
        array $attributeNames
    ) {
        if ($searchCriteria->getSortOrders()) {
            $page = $this->registry->registry('amasty_xlanding_page');

            foreach ($searchCriteria->getSortOrders() as $sortOrder) {
                if ($sortOrder->getField() == 'position'
                    && $page instanceof PageInterface
                ) {
                    $this->addPositionIndexJoin->execute($collection, $page);
                    $collection->getSelect()->order('cat_index_position ' . $sortOrder->getDirection());
                }
            }
        }

        return $result ?? $collection;
    }
}
