<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

namespace Amasty\XlandingGraphQl\Model;

use Magento\Framework\GraphQl\Query\Resolver\TypeResolverInterface;

class XlandingTypeResolver implements TypeResolverInterface
{
    public const AMASTY_XLANDING = 'AMASTY_XLANDING';

    public const TYPE_RESOLVER = 'Landing';

    /**
     * @inheritdoc
     */
    public function resolveType(array $data): string
    {
        if (isset($data['type_id']) && $data['type_id'] == self::AMASTY_XLANDING) {
            return self::TYPE_RESOLVER;
        }

        return '';
    }
}
