<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

namespace Amasty\XlandingGraphQl\Model\Resolver\UrlRewrite;

use Amasty\Xlanding\Model\Page;
use Magento\Framework\GraphQl\Query\Resolver\IdentityInterface;

class LandingUrlResolverIdentity implements IdentityInterface
{
    public function getIdentities(array $resolvedData): array
    {
        $ids = [];
        if (isset($resolvedData['id'])) {
            $ids =  [Page::CACHE_TAG, sprintf('%s_%s', Page::CACHE_TAG, $resolvedData['id'])];
        }

        return $ids;
    }
}
