<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

namespace Amasty\XlandingGraphQl\Model\Resolver;

use Amasty\XlandingGraphQl\Model\ExtractDataFromPage;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class Landing implements ResolverInterface
{
    /**
     * @var ExtractDataFromPage
     */
    private $extractDataFromPage;

    public function __construct(
        ExtractDataFromPage $extractDataFromPage
    ) {
        $this->extractDataFromPage = $extractDataFromPage;
    }

    /**
     * @param Field $field
     * @param \Magento\Framework\GraphQl\Query\Resolver\ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array|\Magento\Framework\GraphQl\Query\Resolver\Value|mixed
     * @throws \Exception
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        try {
            $storeId = (int) $context->getExtensionAttributes()->getStore()->getId();
            $pageData = $this->extractDataFromPage->extract((int) $args['id'], $storeId);
        } catch (NoSuchEntityException $e) {
            throw new GraphQlInputException(__('The requested Landing Page doesn\'t exist.'));
        }

        return $pageData;
    }
}
