<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Landing Pages GraphQl for Magento 2 (System)
 */

namespace Amasty\XlandingGraphQl\Model\DataProvider\UrlRewrite;

use Amasty\XlandingGraphQl\Model\ExtractDataFromPage;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\UrlRewriteGraphQl\Model\DataProvider\EntityDataProviderInterface;

class LandingPageDataProvider implements EntityDataProviderInterface
{
    /**
     * @var ExtractDataFromPage
     */
    private $extractDataFromPage;

    public function __construct(ExtractDataFromPage $extractDataFromPage)
    {
        $this->extractDataFromPage = $extractDataFromPage;
    }

    /**
     * Get landing page data
     *
     * @param string $entity_type
     * @param int $id
     * @param ResolveInfo|null $info
     * @param int|null $storeId
     * @return array
     * @throws GraphQlNoSuchEntityException
     */
    public function getData(
        string $entity_type,
        int $id,
        ResolveInfo $info = null,
        int $storeId = null
    ): array {
        try {
            $result = $this->extractDataFromPage->extract((int) $id, $storeId)->getData();
        } catch (NoSuchEntityException $e) {
            throw new GraphQlInputException(__('The requested Landing Page doesn\'t exist.'));
        }

        return $result;
    }
}
