<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Setup;

use Amasty\Xlanding\Api\Data\PageInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    private const LANDING_STORE_TABLE = 'amasty_xlanding_page_store';
    private const LANDING_PAGE_PRODUCT = 'amasty_xlanding_page_product';
    private const LANDING_PAGE_PRODUCT_INDEX = 'amasty_xlanding_page_product_index';

    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context): void
    {
        $this->uninstallTables($setup);
        $this->uninstallConfigData($setup);
    }

    private function uninstallTables(SchemaSetupInterface $setup): void
    {
        $tablesToDrop = [
            PageInterface::MAIN_TABLE,
            self::LANDING_STORE_TABLE,
            self::LANDING_PAGE_PRODUCT,
            self::LANDING_PAGE_PRODUCT_INDEX
        ];

        foreach ($tablesToDrop as $table) {
            $setup->getConnection()->dropTable(
                $setup->getTable($table)
            );
        }
    }

    private function uninstallConfigData(SchemaSetupInterface $setup): void
    {
        $configTable = $setup->getTable('core_config_data');
        $setup->getConnection()->delete($configTable, "`path` LIKE 'amasty_xlanding%'");
    }
}
