<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Setup\Patch\Data;

use Amasty\Xlanding\Api\Data\PageInterface;
use Magento\Catalog\Model\Category;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class CreateAttributes implements DataPatchInterface
{
    /**
     * @var EavSetup
     */
    private $eavSetup;

    public function __construct(EavSetupFactory $eavSetupFactory, ModuleDataSetupInterface $setup)
    {
        $this->eavSetup = $eavSetupFactory->create(['setup' => $setup]);
    }

    public function apply(): self
    {
        if (!$this->eavSetup->getAttribute(Category::ENTITY, PageInterface::IS_CATEGORY_DYNAMIC)) {
            $this->eavSetup->addAttribute(
                Category::ENTITY,
                PageInterface::IS_CATEGORY_DYNAMIC,
                [
                    'type' => 'int',
                    'label' => 'Is dynamic category',
                    'visible' => true,
                    'input' => null,
                    'default' => 0,
                    'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                    'note' => "Get products from Landing Page",
                    'group' => 'General Information',
                    'sort_order' => 900
                ]
            );
            $this->eavSetup->updateAttribute(
                Category::ENTITY,
                PageInterface::IS_CATEGORY_DYNAMIC,
                'frontend_input',
                null
            );
        }

        if (!$this->eavSetup->getAttribute(Category::ENTITY, PageInterface::DYNAMIC_CATEGORY_PAGE_ID)) {
            $this->eavSetup->addAttribute(
                Category::ENTITY,
                PageInterface::DYNAMIC_CATEGORY_PAGE_ID,
                [
                    'type' => 'int',
                    'label' => 'Landing Page Id',
                    'visible' => true,
                    'input' => null,
                    'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                    'default' => 0,
                    'group' => 'General Information',
                    'sort_order' => 901
                ]
            );
            $this->eavSetup->updateAttribute(
                Category::ENTITY,
                PageInterface::DYNAMIC_CATEGORY_PAGE_ID,
                'frontend_input',
                null
            );
        }

        return $this;
    }

    public function getAliases(): array
    {
        return [];
    }

    public static function getDependencies(): array
    {
        return [];
    }
}
