<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Setup\Patch\Data;

use Magento\Catalog\Model\CategoryRepository;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Psr\Log\LoggerInterface;

class ApplyIsAnchorForRootCategories implements DataPatchInterface
{
    private const ROOT_CATEGORY_LEVEL = 1;

    /**
     * @var CategoryCollectionFactory
     */
    private $categoryCollectionFactory;

    /**
     * @var CategoryRepository
     */
    private $categoryRepository;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        CategoryCollectionFactory $categoryCollectionFactory,
        CategoryRepository $categoryRepository,
        LoggerInterface $logger
    ) {
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->categoryRepository = $categoryRepository;
        $this->logger = $logger;
    }

    public function apply(): self
    {
        try {
            $rootCategories = $this->categoryCollectionFactory->create();
            $rootCategories
                ->addAttributeToSelect('*')
                ->addAttributeToFilter('level', self::ROOT_CATEGORY_LEVEL);

            foreach ($rootCategories as $category) {
                if (!$category->getIsAnchor()) {
                    $category->setIsAnchor(true);
                    $this->categoryRepository->save($category);
                }
            }
        } catch (CouldNotSaveException $e) {
            $this->logger->error($e->getMessage());
        }

        return $this;
    }

    public function getAliases(): array
    {
        return [];
    }

    public static function getDependencies(): array
    {
        return [CreateAttributes::class];
    }
}
