<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Plugin\ElasticSearch\Model\Adapter;

class AdditionalBatchDataMapper
{
    public const FIELD_NAME = 'landing_page_id';
    public const FIELD_NAME_POSITION_TEMPLATE = 'landing_page_position_%s';
    public const INDEX_DOCUMENT = 'document';

    /**
     * @var \Amasty\Xlanding\Model\ResourceModel\Page
     */
    private $pageResource;

    public function __construct(\Amasty\Xlanding\Model\ResourceModel\Page $pageResource)
    {
        $this->pageResource = $pageResource;
    }

    /**
     * Prepare index data for using in search engine metadata.
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     * @param $subject
     * @param callable $proceed
     * @param array $documentData
     * @param $storeId
     * @param array $context
     * @return array
     */
    public function aroundMap(
        $subject,
        callable $proceed,
        array $documentData,
        $storeId,
        $context = []
    ) {
        $documentData = $proceed($documentData, $storeId, $context);
        $pageIdsByProduct = $this->pageResource->getIndexPageIdsByProductId(array_keys($documentData), $storeId);
        foreach ($documentData as $productId => $document) {
            if (isset($pageIdsByProduct[$productId]) && !empty($pageIdsByProduct[$productId])) {
                foreach ($pageIdsByProduct[$productId] as $pageId => $position) {
                    $document[self::FIELD_NAME][] = $pageId;
                    $document[sprintf(self::FIELD_NAME_POSITION_TEMPLATE, $pageId)] = $position;
                }

                $documentData[$productId] = $document;
            }
        }
        return $documentData;
    }
}
