<?php

declare(strict_types = 1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Plugin\Catalog\Model\Category\DataProvider;

use Magento\Catalog\Model\Category\DataProvider;

class AddAmlandingIsDynamic
{
    /**
     * @see DataProvider::getMeta()
     *
     * @param DataProvider $subject
     * @param array $meta
     * @return array
     */
    public function afterGetMeta(DataProvider $subject, array $meta): array
    {
        $meta['general']['children']['amlanding_is_dynamic']['arguments']['data']['config'] = [
            'dataType' => 'boolean',
            'formElement' => 'checkbox',
            'visible' => true,
            'required' => true,
            'label' => __('Dynamic Category'),
            'sortOrder' => '997',
            'notice' => __('Get products from Landing Page'),
            'default' => '0',
            'size' => null,
            'validation' => ['required-entry' => true],
            'scopeLabel' => '[GLOBAL]',
            'componentType' => 'field',
            'disabled' => false,
            'component' => 'Amasty_Xlanding/js/form/element/amlanding_is_dynamic',
            'source' => 'category',
            'prefer' => 'toggle',
            'valueMap' => ['true' => '1', 'false' => '0'],
            'tooltip' => [
                'description' => __(
                    'The category products will be displayed based on Amasty Landing Page conditions. At the same'
                    . ' time, the landing page is not accessible by a direct link (302 redirect to category page)'
                    . ' or seen on the sitemap.'
                )
            ]
        ];

        return $meta;
    }
}
