<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Plugin\Catalog\Helper\Product\ProductList;

use Closure;
use Magento\Catalog\Helper\Product\ProductList;
use Magento\Framework\Registry;

class ChangeDefaultSortField
{
    /**
     * @var Registry
     */
    private $registry;

    public function __construct(Registry $registry)
    {
        $this->registry = $registry;
    }

    public function aroundGetDefaultSortField(ProductList $subject, Closure $proceed): ?string
    {
        $page = $this->registry->registry('amasty_xlanding_page');

        if ($page && $page->getDefaultSortBy()) {
            $result = $page->getDefaultSortBy();
        } else {
            $result = $proceed();
        }

        return $result;
    }
}
