<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Model\Rule\Condition\Price;

class Sale extends AbstractPrice
{
    /**
     * @var string
     */
    protected $_inputType = 'select';

    public function getAttributeElementHtml()
    {
        return __('Is on Sale');
    }

    protected function _getAttributeCode()
    {
        return 'sale';
    }

    public function getInputType()
    {
        return 'select';
    }

    public function getValueElementType()
    {
        return 'select';
    }

    protected function _prepareValueOptions()
    {
        $selectReady = $this->getData('value_select_options');
        $hashedReady = $this->getData('value_option');

        $selectOptions = [
            ['value' => 1, 'label' => 'Yes'],
            ['value' => 0, 'label' => 'No']
        ];

        $this->_setSelectOptions($selectOptions, $selectReady, $hashedReady);

        return $this;
    }

    protected function _getCondition()
    {
        if (!$this->_condition) {
            $alias = $this->_getAlias();

            $value     = $this->getValue();
            $operator  = $this->getOperatorForValidate();
            $condition = [];

            if ($value && $operator == '==') {
                $condition[] = 'ifnull(catalog_rule.rule_price, ' . $alias . '.final_price) < ' . $alias . '.price';
            } else {
                $condition[] = 'ifnull(catalog_rule.rule_price, ' . $alias . '.final_price) >= ' . $alias . '.price';
            }

            $condition[] = '(catalog_rule.latest_start_date < NOW() OR catalog_rule.latest_start_date IS NULL)';
            $condition[] = '(catalog_rule.earliest_end_date > NOW() OR catalog_rule.earliest_end_date IS NULL)';
            $this->_condition = implode(' AND ', $condition);
        }
        return $this->_condition;
    }
}
