<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Model\ResourceModel\Page\Product;

class Collection extends \Magento\Catalog\Model\ResourceModel\Product\Collection
{
    /**
     * @param $positionData
     * @return array
     */
    public function getProductInfoByIds($positionData)
    {
        $this->_beforeLoad();
        $this->_renderFilters();
        $this->_renderOrders();
        $select = clone $this->getSelect();
        $select->reset(\Magento\Framework\DB\Select::COLUMNS);
        $select->columns('e.entity_id');
        $select->group('e.entity_id');

        return $this->sortIds($this->getConnection()->fetchCol($select), $positionData);
    }

    /**
     * @return $this
     */
    protected function _beforeLoad()
    {
        $this->_eventManager->dispatch(
            'amasty_xlanding_collection_before_load',
            ['data_object' => $this]
        );

        return parent::_beforeLoad();
    }

    /**
     * @param array $ids
     * @return array
     */
    private function sortIds($ids, $positionData)
    {
        $positionData = $this->preparePositionData($positionData, $ids);
        $ids = array_diff($ids, $positionData);
        $itemsCount = count($ids) + count($positionData);
        $idx = 0;
        while ($idx < $itemsCount) {
            if (!isset($positionData[$idx]) && key($ids) !== null) {
                $positionData[$idx] = current($ids);
                next($ids);
            }
            $idx++;
        }

        ksort($positionData, SORT_NUMERIC);

        return $positionData;
    }

    /**
     * @param array $ids
     * @return array
     */
    protected function preparePositionData($positionData, $ids)
    {
        $positionData = array_intersect($positionData, $ids);
        $maxPosition = count($ids) - 1;
        foreach ($positionData as $position => $productId) {
            if ($position > $maxPosition) {
                $positionData[$maxPosition] = $productId;
                $maxPosition--;
            }
        }

        return $positionData;
    }
}
