<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Model\Indexer;

class ProductPage extends AbstractIndexer
{
    public const INDEXER_ID = 'amasty_xlanding_product_page';

    /**
     * @inheritdoc
     */
    protected function doExecuteRow($id)
    {
        $this->getIndexBuilder()->reindexByProductIds([$id]);
    }

    /**
     * @inheritdoc
     */
    protected function doExecuteList($ids)
    {
        $this->getIndexBuilder()->reindexByProductIds($ids);
    }

    /**
     * @return bool
     */
    protected function isUpdateOnSaveAvailable(): bool
    {
        return $this->data[static::FORCED_FLAG] ?? false;
    }
}
