<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Model\Indexer\Mview;

use Amasty\Xlanding\Model\Indexer\PageProductProcessor;
use Magento\Framework\Mview\ActionInterface;

class PageProductAction implements ActionInterface
{
    /**
     * @var PageProductProcessor
     */
    private $pageProductProcessor;

    public function __construct(PageProductProcessor $pageProductProcessor)
    {
        $this->pageProductProcessor = $pageProductProcessor;
    }

    /**
     * @param int[] $ids
     * @return void
     */
    public function execute($ids)
    {
        $this->pageProductProcessor->reindexList($ids, true);
    }
}
