<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Model;

use Amasty\Base\Model\ConfigProviderAbstract;
use Magento\Store\Model\ScopeInterface;

class ConfigProvider extends ConfigProviderAbstract
{
    public const CONFIG_PATH_SEARCH_ENGINE = 'catalog/search/engine';

    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_xlanding/';

    /**
     * @return bool
     */
    public function isElasticSearchEnabled(): bool
    {
        $searchEngine = $this->getSearchEngine();
        return strpos($searchEngine, 'elast') !== false || $searchEngine === 'opensearch';
    }

    /**
     * @return string
     */
    public function getSearchEngine(): string
    {
        return (string) $this->scopeConfig->getValue(self::CONFIG_PATH_SEARCH_ENGINE, ScopeInterface::SCOPE_STORE);
    }
}
