<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Cron;

use Psr\Log\LoggerInterface;
use Magento\Indexer\Model\Indexer;

class LandingPagesReindex
{
    public const CATALOGSEARCH_INDEXER_ID = 'catalogsearch_fulltext';
    public const PRODUCT_ATTRIBUTES_INDEXER_ID = 'catalog_product_attribute';
    public const LANDING_PAGE_INDEXER_ID = 'amasty_xlanding_page_product';

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var Indexer
     */
    private $indexer;

    public function __construct(
        LoggerInterface $logger,
        Indexer $indexer
    ) {
        $this->logger = $logger;
        $this->indexer = $indexer;
    }

    /**
     * @return void
     */
    public function execute()
    {
        $indexers = [
            self::PRODUCT_ATTRIBUTES_INDEXER_ID,
            self::LANDING_PAGE_INDEXER_ID,
            self::CATALOGSEARCH_INDEXER_ID
        ];
        try {
            foreach ($indexers as $indexer) {
                $this->indexer->load($indexer);
                $this->indexer->reindexAll();
            }
        } catch (\Exception $e) {
            $this->logError($e);
        }
    }

    /**
     * @param \Exception $e
     */
    private function logError(\Exception $e)
    {
        $this->logger->error($e->getMessage());
    }
}
