<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Landing Pages for Magento 2
 */

namespace Amasty\Xlanding\Controller\Adminhtml\Export;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Amasty\Xlanding\Model\Export\ConvertToCsv;
use Magento\Framework\App\Response\Http\FileFactory;

class GridToCsv extends Action
{
    /**
     * @var ConvertToCsv
     */
    protected $_converter;

    /**
     * @var FileFactory
     */
    protected $_fileFactory;

    public function __construct(
        Context $context,
        ConvertToCsv $converter,
        FileFactory $fileFactory
    ) {
        parent::__construct($context);
        $this->_converter = $converter;
        $this->_fileFactory = $fileFactory;
    }

    public function execute()
    {
        return $this->_fileFactory->create('export.csv', $this->_converter->getCsvFile(), 'var');
    }
}
