/**
 * multiple-wish mixin
 */

define([
    'jquery',
    'Magento_Catalog/js/action/am-product-actions',
    'Magento_Customer/js/customer-data'
], function ($, amProductActions, customerData) {
    'use strict';

    var multipleWishlistMixin = {
        _create: function () {
            this._super();

            $('body').on('popup.amContentUpdated', function () {
                this._buildWishlistDropdown();
            }.bind(this));

            customerData.get('wishlist').subscribe(function () {
                amProductActions.highlightWishlistProducts();
            });
        },

        /** @inheritDoc */
        _createEditWishlistModal: function (e) {
            var self = this,
                json = $(e.currentTarget).data('wishlist-edit');

            this.options.editTmplData.url = json.url;
            this.options.editTmplData.name = json.name;
            this.options.editTmplData.isPublic = json.isPublic;

            $.mage.promptEditWithList({
                modalClass: ' custom-slide ' + json.modalClass,
                title: json.title,
                value: this.options.editTmplData.name,
                label: $.mage.__('Wish List Name'),
                isPublicFieldLabel: $.mage.__('Public Wish List'),
                isPublicFieldAttributeName: 'visibility',
                isPublicFieldChecked: this.options.editTmplData.isPublic,
                hiddenFieldValue: json.formKey,
                attributesField: {
                    name: 'name',
                    'data-validate': '{required:true}',
                    maxlength: '255'
                },
                attributesForm: {
                    id: this.options.editTmplData.popupWishlistFormId,
                    action: this.options.editTmplData.url,
                    novalidate: 'novalidate'
                },
                buttons: [{
                    text: $.mage.__('Save'),
                    class: 'action primary',

                    click: function () {
                        $.ajax({
                            url: self.options.editTmplData.url,
                            data: $('#' + self.options.editTmplData.popupWishlistFormId)
                                .serialize(),
                            dataType: 'json',
                            method: 'post'
                        }).done(function (data) {
                            window.location.href = data.redirect;
                        });
                    }
                }, {
                    text: $.mage.__('Close'),
                    class: 'action secondary button-as-link',

                    click: function () {
                        this.closeModal();
                        this.modal.one(this.options.transitionEvent, function () {
                            this._remove();
                        }.bind(this, arguments));
                    }
                }]
            });

            return false;
        },

        /** @inheritDoc */
        _buildWishlistDropdown: function () {
            this._super();

            amProductActions.highlightWishlistProducts();

            return this;
        }

    };

    return function (targetWidget) {
        $.widget('mage.multipleWishlist', targetWidget, multipleWishlistMixin);

        return $.mage.multipleWishlist;
    };
});
