<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Common Rules for Magento 2 (System)
 */

namespace Amasty\CommonRules\Observer\Admin;

class DeleteConditionHandle implements \Magento\Framework\Event\ObserverInterface
{
    public const NOT_SUPPORTED_CONDITIONS = [
        'Amasty\Conditions\Model\Rule\Condition\Address|payment_method',
    ];

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    private $request;

    public function __construct(\Magento\Framework\App\Request\Http $request)
    {
        $this->request = $request;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return DeleteConditionHandle
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $moduleName = $this->request->getModuleName();

        if ($this->isCommonRulesModule($moduleName)
            && is_array($conditions = $observer->getAdditional()->getConditions())
        ) {
            $promoConditions = [];

            foreach ($conditions as $condition) {
                if ($this->isAdvancedConditions($condition)) {
                    foreach ($condition['value'] as $key => $condAttribute) {
                        if (in_array($condAttribute['value'], self::NOT_SUPPORTED_CONDITIONS)) {
                            unset($condition['value'][$key]);
                        }
                    }
                }
                $promoConditions[] = $condition;
            }

            $observer->getAdditional()->setConditions($promoConditions);
        }

        return $this;
    }

    /**
     * @param $condition
     *
     * @return bool
     */
    private function isAdvancedConditions($condition)
    {
        return is_array($condition)
            && isset($condition['label'])
            && $condition['label']->getText() === \Amasty\Conditions\Model\Constants::MODULE_NAME;
    }

    /**
     * @param $moduleName
     *
     * @return bool
     */
    private function isCommonRulesModule($moduleName)
    {
        return $moduleName === 'amasty_shiprestriction'
            || $moduleName === 'amasty_shiprules'
            || $moduleName === 'amasty_payrestriction';
    }
}
