<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Custom Stock Status GraphQl for Magento 2 (System)
 */

namespace Amasty\StockstatusGraphQl\Plugin\Framework\App\Http\Context;

use Magento\Authorization\Model\UserContextInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\Context;
use Magento\Framework\App\Http\Context as HttpContext;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\PageCache\Model\Config as PageConfig;
use Psr\Log\LoggerInterface;

class AddCustomerData
{
    /**
     * @var PageConfig
     */
    private $pageConfig;

    /**
     * @var UserContextInterface
     */
    private $userContext;

    /**
     * @var CustomerRepositoryInterface
     */
    private $customerRepository;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        PageConfig $pageConfig,
        UserContextInterface $userContext,
        CustomerRepositoryInterface $customerRepository,
        LoggerInterface $logger
    ) {
        $this->pageConfig = $pageConfig;
        $this->userContext = $userContext;
        $this->customerRepository = $customerRepository;
        $this->logger = $logger;
    }

    /**
     * @param HttpContext $subject
     * @param array $data
     * @return array
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetData(
        HttpContext $subject,
        array $data
    ): array {
        if ($this->pageConfig->isEnabled()
            && $this->userContext->getUserType() === UserContextInterface::USER_TYPE_CUSTOMER
            && $this->userContext->getUserId()
        ) {
            try {
                $customer = $this->customerRepository->getById($this->userContext->getUserId());
                $data[Context::CONTEXT_GROUP] = $customer->getGroupId();
            } catch (NoSuchEntityException|LocalizedException $e) {
                $this->logger->error($e->getMessage());
            }
        }

        return $data;
    }
}
