<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Custom Stock Status GraphQl for Magento 2 (System)
 */

namespace Amasty\StockstatusGraphQl\Model\Customer;

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;

class Emulator
{
    /**
     * @var int|null
     */
    private $previousCustomerId;

    /**
     * @var int|null
     */
    private $previousCustomerGroupId;

    /**
     * @var CustomerSession
     */
    private $customerSession;

    /**
     * @var CustomerRepositoryInterface
     */
    private $customerRepository;

    public function __construct(CustomerSession $customerSession, CustomerRepositoryInterface $customerRepository)
    {
        $this->customerSession = $customerSession;
        $this->customerRepository = $customerRepository;
    }

    /**
     * @param int|null $customerId
     * @return void
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function start(?int $customerId): void
    {
        $this->previousCustomerId = $this->customerSession->getCustomerId();
        $this->previousCustomerGroupId = $this->customerSession->getCustomerGroupId();

        if ($customerId) {
            $customer = $this->customerRepository->getById($customerId);

            $this->customerSession->setCustomerId($customer->getId());
            $this->customerSession->setCustomerGroupId($customer->getGroupId());
            $this->customerSession->setIsCustomerEmulated(true);
        }
    }

    public function stop(): void
    {
        $this->customerSession->setCustomerId($this->previousCustomerId);
        $this->customerSession->setCustomerGroupId($this->previousCustomerGroupId);
        $this->customerSession->setIsCustomerEmulated(false);
    }
}
