<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Setup\Patch\Data;

use Magento\Catalog\Model\Product;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class UpdateDeprecatedAttributes implements DataPatchInterface
{
    public const ATTRIBUTES_TO_UPDATE = [
        'custom_stock_status_qty_based',
        'custom_stock_status_qty_rule'
    ];

    /**
     * @var EavSetup
     */
    private $eavSetup;

    /**
     * @var ModuleDataSetupInterface
     */
    private $setup;

    public function __construct(
        EavSetupFactory $eavSetupFactory,
        ModuleDataSetupInterface $setup
    ) {
        $this->eavSetup = $eavSetupFactory->create(['setup' => $setup]);
        $this->setup = $setup;
    }

    public function apply(): self
    {
        foreach (self::ATTRIBUTES_TO_UPDATE as $attributeCode) {
            $attributeId = $this->eavSetup->getAttributeId(
                Product::ENTITY,
                $attributeCode
            );

            if ($attributeId) {
                // remove attribute from all attributes sets
                // because deprecated and must not be configured in product page
                $this->setup->getConnection()->delete(
                    $this->setup->getTable('eav_entity_attribute'),
                    ['attribute_id = ?' => $attributeId]
                );

                $this->setup->updateTableRow(
                    'catalog_eav_attribute',
                    'attribute_id',
                    $attributeId,
                    [
                        'is_visible' => 1,
                        'is_used_for_promo_rules' => 1
                    ]
                );

                $this->eavSetup->updateAttribute(
                    Product::ENTITY,
                    $attributeId,
                    'is_user_defined',
                    1
                );

                $attributeLabel = $this->eavSetup->getAttribute(
                    Product::ENTITY,
                    $attributeCode,
                    'frontend_label'
                );

                $this->eavSetup->updateAttribute(
                    Product::ENTITY,
                    $attributeId,
                    'frontend_label',
                    sprintf('%s (Deprecated)', $attributeLabel)
                );
            }
        }

        return $this;
    }

    public function getAliases(): array
    {
        return [];
    }

    public static function getDependencies(): array
    {
        return [];
    }
}
