<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class ChangeSettings implements DataPatchInterface
{
    /**
     * @var string[]
     */
    private $changedSettings = [
        'amstockstatus/general/stockalert' => 'amstockstatus/configurable_products/stockalert',
        'amstockstatus/general/outofstock' => 'amstockstatus/configurable_products/outofstock',
        'amstockstatus/general/change_custom_configurable_status' =>
            'amstockstatus/configurable_products/change_custom_configurable_status',
        'amstockstatus/general/hide_default_status' => 'amstockstatus/general/display_default_status'
    ];

    /**
     * @var ModuleDataSetupInterface
     */
    private $setup;

    public function __construct(
        ModuleDataSetupInterface $setup
    ) {
        $this->setup = $setup;
    }

    public function apply(): self
    {
        foreach ($this->changedSettings as $actual => $needed) {
            $connection = $this->setup->getConnection();
            $tableName = $this->setup->getTable('core_config_data');

            $select = $connection->select()
                ->from($tableName, ['config_id', 'value'])
                ->where('path = ?', $actual);

            $settings = $connection->fetchAll($select);

            foreach ($settings as $row) {
                $connection->update(
                    $tableName,
                    ['path' => $needed],
                    ['config_id = ?' => $row['config_id']]
                );
            }
        }

        return $this;
    }

    public function getAliases(): array
    {
        return [];
    }

    public static function getDependencies(): array
    {
        return [];
    }
}
