<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Plugin\ShopbyBase\Block\Adminhtml\Catalog\Product\Attribute;

use Amasty\Stockstatus\Model\Source\StockStatus;

class EditPlugin
{
    /**
     * @param \Amasty\ShopbyBase\Block\Adminhtml\Catalog\Product\Attribute\Edit $subject
     * @param string $result
     * @return string
     */
    public function afterToHtml(
        $subject,
        string $result
    ): string {
        return $subject->getFilterCode() === 'attr_' . StockStatus::ATTIRUBTE_CODE ? '' : $result;
    }
}
