<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Plugin\HidePrice\Helper;

use Amasty\Stockstatus\Model\Stockstatus\IsHidePrice;
use Magento\Catalog\Api\Data\ProductInterface;

class Data
{
    /**
     * @var IsHidePrice
     */
    private $isHidePrice;

    public function __construct(IsHidePrice $isHidePrice)
    {
        $this->isHidePrice = $isHidePrice;
    }

    public function afterCheckStockStatus($subject, bool $result, bool $resultBefore, ProductInterface $product): bool
    {
        if ($this->isHidePrice->execute($product)) {
            $result = true;
        }

        return $result;
    }
}
