<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Plugin\GroupedProduct\Model\Product\Type;

use Amasty\Stockstatus\Model\Backend\UpdaterAttribute;
use Amasty\Stockstatus\Model\Source\StockStatus;
use Magento\Catalog\Model\ResourceModel\Product\Link\Product\Collection;
use Magento\GroupedProduct\Model\Product\Type\Grouped;

class GroupedPlugin
{
    public function afterGetAssociatedProductCollection(Grouped $subject, Collection $collection): Collection
    {
        $collection->addAttributeToSelect([StockStatus::ATTIRUBTE_CODE, UpdaterAttribute::EXPECTED_DATE_CODE]);

        return $collection;
    }
}
