<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Plugin\CatalogWidget\Block\Product\ProductsList;

use Amasty\Stockstatus\Model\Stockstatus\Renderer\Status\ProductsList\RemoveDefaultStatusJs;
use Magento\CatalogWidget\Block\Product\ProductsList;

class RemoveDefaultStatus
{
    /**
     * @var RemoveDefaultStatusJs
     */
    private $removeDefaultStatusJs;

    public function __construct(
        RemoveDefaultStatusJs $removeDefaultStatusJs
    ) {
        $this->removeDefaultStatusJs = $removeDefaultStatusJs;
    }

    public function afterToHtml(ProductsList $subject, string $result): string
    {
        return $result . $this->removeDefaultStatusJs->getScript();
    }
}
