<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Plugin\CatalogWidget\Block\Product\ProductsList;

use Amasty\Stockstatus\Model\Stockstatus\Renderer\Status\ProductsList\Status as ProductsListStatusRenderer;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\CatalogWidget\Block\Product\ProductsList;

class AppendStatus
{
    /**
     * @var ProductsListStatusRenderer
     */
    private $productsListStatusRenderer;

    public function __construct(
        ProductsListStatusRenderer $productsListStatusRenderer
    ) {
        $this->productsListStatusRenderer = $productsListStatusRenderer;
    }

    public function afterGetProductPriceHtml(ProductsList $subject, string $result, ProductInterface $product): string
    {
        return $result . $this->productsListStatusRenderer->render($product);
    }
}
