<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\StockstatusSettings;

use Amasty\Stockstatus\Api\StockstatusSettings\RemoveStockstatusSettingsIconFileInterface;
use Amasty\Stockstatus\Api\StockstatusSettingsRepositoryInterface;
use Amasty\Stockstatus\Model\Icon\RemoveIconFileByPath;

class RemoveStockstatusSettingsIconFile implements RemoveStockstatusSettingsIconFileInterface
{
    /**
     * @var StockstatusSettingsRepositoryInterface
     */
    private $stockstatusSettingsRepository;

    /**
     * @var RemoveIconFileByPath
     */
    private $removeIconFileByPath;

    public function __construct(
        StockstatusSettingsRepositoryInterface $stockstatusSettingsRepository,
        RemoveIconFileByPath $removeIconFileByPath
    ) {
        $this->stockstatusSettingsRepository = $stockstatusSettingsRepository;
        $this->removeIconFileByPath = $removeIconFileByPath;
    }

    public function execute(int $optionId, int $storeId): void
    {
        $stockStatusSetting = $this->stockstatusSettingsRepository->getByOptionIdAndStoreId($optionId, $storeId);
        $this->removeIconFileByPath->execute($stockStatusSetting->getImagePath());
    }
}
