<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\Stockstatus\Specification;

use Magento\Catalog\Api\Data\ProductInterface;

interface SpecificationInterface
{
    /**
     * Check if product suitable for current specification.
     *
     * @param ProductInterface $product
     * @return int|null
     */
    public function resolve(ProductInterface $product): ?int;
}
