<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\Stockstatus\Specification;

use Amasty\Stockstatus\Model\Rule\GetRuleForProduct;
use Magento\Catalog\Api\Data\ProductInterface;

class RuleStatus implements SpecificationInterface
{
    /**
     * @var GetRuleForProduct
     */
    private $getRuleForProduct;

    public function __construct(GetRuleForProduct $getRuleForProduct)
    {
        $this->getRuleForProduct = $getRuleForProduct;
    }

    public function resolve(ProductInterface $product): ?int
    {
        $appliedRule = $this->getRuleForProduct->execute((int) $product->getId(), $product->getStoreId());
        if ($appliedRule) {
            $product->getExtensionAttributes()->getStockstatusInformation()->setRuleId((int) $appliedRule->getId());
            $statusId = $appliedRule->getStockStatus();
        }

        return $statusId ?? null;
    }
}
