<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\Stockstatus\Renderer\Status\ProductsList;

use Amasty\Stockstatus\Model\ConfigProvider;
use Amasty\Stockstatus\Model\Stockstatus\Processor;
use Amasty\Stockstatus\Model\Stockstatus\Renderer\Info as InfoRenderer;
use Amasty\Stockstatus\Model\Stockstatus\Renderer\Status as StatusRenderer;
use Magento\Catalog\Api\Data\ProductInterface;

class Status
{
    /**
     * @var Processor
     */
    private $processor;

    /**
     * @var StatusRenderer
     */
    private $statusRenderer;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var InfoRenderer
     */
    private $infoRenderer;

    public function __construct(
        ConfigProvider $configProvider,
        Processor $processor,
        StatusRenderer $statusRenderer,
        InfoRenderer $infoRenderer
    ) {
        $this->processor = $processor;
        $this->statusRenderer = $statusRenderer;
        $this->configProvider = $configProvider;
        $this->infoRenderer = $infoRenderer;
    }

    public function render(ProductInterface $product): string
    {
        $html = '';

        if ($this->configProvider->isDisplayedOnCategory()) {
            $this->processor->execute([$product]);
            $status = $this->statusRenderer->render($product, true, true);
            if ($status != '') {
                $status = sprintf(
                    '<div class="amstockstatus-category">%s</div>',
                    $status . $this->infoRenderer->render()
                );
            }

            $html .= $status;
        }

        return $html;
    }
}
