<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\Stockstatus\Renderer\Status\ProductsList;

use Amasty\Stockstatus\Model\ConfigProvider;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Asset\Repository as AssetRepository;
use Psr\Log\LoggerInterface;

class RemoveDefaultStatusJs
{
    protected const SCRIPT_PATH = 'Amasty_Stockstatus::js/product/list/remove-default-status.js';

    /**
     * @var AssetRepository
     */
    private $assetRepository;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        AssetRepository $assetRepository,
        ConfigProvider $configProvider,
        LoggerInterface $logger
    ) {
        $this->assetRepository = $assetRepository;
        $this->configProvider = $configProvider;
        $this->logger = $logger;
    }

    public function getScript(): string
    {
        $result = '';
        try {
            if ($this->configProvider->isDisplayedOnCategory()) {
                $asset = $this->assetRepository->createAsset(self::SCRIPT_PATH);
                $result = $this->formatScript($asset->getUrl());
            }
        } catch (LocalizedException $e) {
            $this->logger->error($e->getMessage());
        }

        return $result;
    }

    private function formatScript(string $path): string
    {
        return sprintf('<script type="text/javascript" src="%s"></script>', $path);
    }
}
