<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;

class Outofstock implements OptionSourceInterface
{
    public const MAGENTO_LOGIC = 0;

    public const SHOW = 1;

    public const SHOW_AND_CROSSED = 2;

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => self::MAGENTO_LOGIC,
                'label' => __('No, Magento logic')
            ],
            [
                'value' => self::SHOW,
                'label' => __('Yes, Out of stock options selectable')
            ],
            [
                'value' => self::SHOW_AND_CROSSED,
                'label' => __('Yes, Out of stock options selectable and crossed-out')
            ]
        ];
    }
}
