<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\ResourceModel;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Adapter\AdapterInterface;

class RuleIndex
{
    public const MAIN_TABLE = 'amasty_stockstatus_rule_index';
    public const REPLICA_TABLE = 'amasty_stockstatus_rule_index_replica';

    public const RULE_ID = 'rule_id';
    public const STORE_ID = 'store_id';
    public const PRODUCT_ID = 'product_id';

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    public function getConnection(): AdapterInterface
    {
        return $this->resourceConnection->getConnection();
    }

    public function getTableName(string $tableName): string
    {
        return $this->resourceConnection->getTableName($tableName);
    }

    public function getAppliedRules(int $productId, int $storeId): array
    {
        $equalsTemplate = '%s = ?';

        $rulesSelect = $this->getConnection()->select()->from(
            $this->getTableName(static::MAIN_TABLE),
            [static::RULE_ID]
        )->where(
            sprintf($equalsTemplate, static::PRODUCT_ID),
            $productId
        )->where(
            sprintf($equalsTemplate, static::STORE_ID),
            $storeId
        );

        return $this->getConnection()->fetchCol($rulesSelect);
    }
}
