<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\ResourceModel;

use Amasty\Stockstatus\Api\Data\RangeInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class Range extends AbstractDb
{
    public const MAIN_TABLE = 'amasty_stockstatus_ranges';

    protected function _construct()
    {
        $this->_init(self::MAIN_TABLE, RangeInterface::ID);
    }

    /**
     * @param int $ruleId
     * @throws LocalizedException
     */
    public function deleteByRuleId(int $ruleId): void
    {
        $this->getConnection()->delete(
            $this->getMainTable(),
            [sprintf('%s IN (?)', RangeInterface::RULE_ID) => $ruleId]
        );
    }
}
