<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\Range;

use Magento\Bundle\Model\Product\Type as BundleType;
use Magento\Catalog\Api\Data\ProductInterface;

class IsAvailableForProduct
{
    /**
     * @var array
     */
    private $nonRangesTypes = [
        BundleType::TYPE_CODE
    ];

    public function execute(ProductInterface $product): bool
    {
        return !in_array($product->getTypeId(), $this->nonRangesTypes);
    }
}
